/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.pagination.BasePaginationMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class RegionFlagPagination
extends BasePaginationMessage<IFlag> {
    private final IProtectedRegion region;

    public RegionFlagPagination(IProtectedRegion region, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(region.getFlags().flags(), Commands.buildListRegionFlagsCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    public static class_5250 buildRegionFlagInfoHeader(IProtectedRegion region, class_5250 flagListLink) {
        return ChatComponentBuilder.buildHeader(class_2561.method_48322((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{flagListLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
    }

    public static List<class_2561> buildRegionFlagEntries(IProtectedRegion region) {
        return RegionFlagPagination.buildRegionFlagEntries(region, region.getFlags().flags());
    }

    public static List<class_2561> buildRegionFlagEntries(IProtectedRegion region, List<IFlag> selectedFlags) {
        ArrayList<class_2561> flagEntries = new ArrayList<class_2561>();
        flagEntries.addAll(RegionFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.DENIED));
        flagEntries.addAll(RegionFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.ALLOWED));
        flagEntries.addAll(RegionFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.DISABLED));
        return flagEntries;
    }

    public static List<class_5250> buildFlagEntriesForState(IProtectedRegion region, List<IFlag> selectedFlags, FlagState state) {
        List<IFlag> flagsByState = selectedFlags.stream().filter(f -> f.getState() == state).sorted(Comparator.comparing(IFlag::getName)).toList();
        return flagsByState.stream().map(flag -> RegionFlagPagination.buildRemoveFlagEntry(region, flag, RegionFlagPagination.colorForState(flag.getState()), new class_124[0])).collect(Collectors.toList());
    }

    public static class_5250 buildRemoveFlagEntry(IProtectedRegion region, IFlag flag, class_124 flagLinkColor, class_124 ... ChatFormattings) {
        String cmd = switch (region.getRegionType()) {
            case RegionType.GLOBAL -> Commands.buildCommandStr(CommandConstants.GLOBAL.toString(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            case RegionType.DIMENSION -> Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().method_29177().toString(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            case RegionType.LOCAL -> Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            default -> throw new IllegalArgumentException();
        };
        class_5250 hoverText = class_2561.method_48322((String)"cli.msg.info.region.flag.remove.link.hover", (String)"Remove flag '%s' from region %s", (Object[])new Object[]{flag.getName(), region.getName()});
        class_5250 linkText = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        class_5250 flagRemoveLink = ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
        class_5250 flagQuickActionComponent = RegionFlagPagination.buildFlagQuickActionComponent(region, flag, flagLinkColor);
        flagQuickActionComponent.method_27695(ChatFormattings);
        return Messages.substitutable(" - %s %s", flagRemoveLink, flagQuickActionComponent);
    }

    public static class_124 colorForState(FlagState state) {
        switch (state) {
            case ALLOWED: {
                return class_124.field_1060;
            }
            case DENIED: {
                return class_124.field_1061;
            }
            case DISABLED: {
                return class_124.field_1080;
            }
        }
        throw new IllegalArgumentException();
    }

    public static class_5250 buildFlagQuickActionComponent(IProtectedRegion region, IFlag flag, class_124 flagLinkColor) {
        class_5250 regionTypeIndicator = class_2561.method_43470((String)region.getRegionType().type.substring(0, 1).toUpperCase());
        class_5250 hoverText = class_2561.method_48322((String)"cli.flag.info.hover", (String)"Show %s flag info of region '%s'", (Object[])new Object[]{flag.getName(), region.getName()});
        class_5250 flagInfoLink = ChatLinkBuilder.buildFlagInfoLink(region, flag, flagLinkColor);
        return Messages.substitutable("%s %s %s %s %s", flagInfoLink, ChatLinkBuilder.buildFlagInfoLink(region, flag, regionTypeIndicator, hoverText, class_124.field_1064), ChatLinkBuilder.buildFlagStateSuggestionLink(region, flag), ChatLinkBuilder.buildFlagMuteToggleLink(region, flag, true), ChatLinkBuilder.buildFlagOverrideToggleLink(region, flag, true));
    }

    @Override
    public class_2561 noContentMsg() {
        return class_2561.method_48322((String)"cli.msg.info.region.flag.empty", (String)"No flags defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(this.region)});
    }

    @Override
    public class_2561 header() {
        return RegionFlagPagination.buildRegionFlagInfoHeader(this.region, ChatLinkBuilder.buildRegionFlagListLink(this.region));
    }

    @Override
    public List<class_2561> buildEntries() {
        return RegionFlagPagination.buildRegionFlagEntries(this.region, this.pageContent);
    }

    @Override
    public class_2561 emptyEntry() {
        return Messages.substitutable(" - %s", ChatLinkBuilder.buildSuggestAddFlagLink(this.region));
    }
}

